using System;
using System.Collections;
using System.Data;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Holds a collection of ProductShipper objects
	/// </summary>
	public class ProductShipperCollection : CollectionBase
	{

		#region Constructors/Destructors

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7633"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7634"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads all the product Shippers for a product within a division
		/// </summary>
		/// <param name="bloodProductGuid"></param>
		public ProductShipperCollection(Guid bloodProductGuid)
		{
			ProductShipper _ProductShipper;

			DataTable dt = DAL.ProductShipper.GetProductShippersByDivision(bloodProductGuid);
			
			foreach(DataRow dr in dt.Rows)
			{
				_ProductShipper = new ProductShipper(dr);
				this.List.Add(_ProductShipper);
			}
		}


		#endregion

		#region Events

		/// <summary>
		/// OnListChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected virtual void OnListChanged(object sender, EventArgs e) 
		{
			if (onListChanged != null) 
			{
				onListChanged(this, e);
			}
		}

		/// <summary>
		/// ListChanged
		/// </summary>
		public event EventHandler ListChanged
		{
			add 
			{
				onListChanged += value;
			}
			remove 
			{
				onListChanged -= value;
			}
		}


		/// <summary>
		/// onListChanged event
		/// </summary>
		private EventHandler onListChanged;

		#endregion

		#region CollectionBase Overrides

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7635"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7636"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <newpara> Function Name: Add</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 8/26/2002</newpara>
		/// <summary> Description: Controls the addition of a ProductShipper to the ProductShippers collection</summary>
		/// <param name="productShipper">ProductShipper</param>
		/// <returns>N/A</returns>	
		public void Add(ProductShipper productShipper)
		{
			bool updated = false;

			foreach(ProductShipper _ps in this)
			{
				if (_ps.LocalSupplierGuid == productShipper.LocalSupplierGuid)
				{

					_ps.RecordStatusCode = productShipper.RecordStatusCode;
					_ps.ProductCost = productShipper.ProductCost;
					_ps.ReturnCreditPercentage = productShipper.ReturnCreditPercentage;
					if (!_ps.IsNew)
						_ps.RowVersion = productShipper.RowVersion;
					updated = true;
				}
				
			}

			if (!updated)
			{
                this.List.Add(productShipper);
			}
			OnListChanged(this, EventArgs.Empty);
		}

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7637"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7638"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <remarks>
		/// <newpara> Function Name: Remove</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 8/26/2002</newpara>
		/// </remarks>
		/// <summary> Description: Controls the removal of a ProductShipper from the ProductShippers collection</summary>
		/// <param name="productShipper">ProductShipper</param>
		/// <returns>N/A</returns>
		public void Remove(ProductShipper productShipper)
		{
			this.List.Remove(productShipper);
			OnListChanged(this, EventArgs.Empty);
		}

	#endregion

		#region Properties

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6522"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6523"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the number of active shippers in the collection
		/// </summary>
		public int ActiveShippersCount
		{
			get
			{
				int activeCtr = 0;

				foreach(ProductShipper _ps in this)
				{
					if (_ps.RecordStatusCode == Common.RecordStatusCode.Active)
					{
						activeCtr++;
					}
				}

				return(activeCtr);
			}
		}
		
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7639"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7640"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ProductShipper
		/// </summary>
		public ProductShipper this[int index] 
		{
			get 
			{
				return (ProductShipper)(List[index]);
			}
			set 
			{
				List[index] = value;
			}
		}

		#endregion

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7641"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7642"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetElementByLocalSupplierGuid
		/// </summary>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public ProductShipper GetElementByLocalSupplierGuid(Guid localSupplierGuid)
		{
			foreach(ProductShipper _ps in this)
			{
				if (_ps.LocalSupplierGuid == localSupplierGuid)
				{
					return _ps;
				}
			}

			return null;
		}

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7643"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7644"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Kinda the same thing as GetElementByLocalSupplierGuid but returns a boolean instead of the object
		/// </summary>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public bool DoesLocalSupplierExist(Guid localSupplierGuid)
		{
			foreach(ProductShipper _ps in this)
			{
				if (_ps.LocalSupplierGuid == localSupplierGuid)
				{
					return true;
				}
			}
			return false;
		}


	}
}